<?php
include('connect.php');

// Check if the data is received via $_GET
if(isset($_GET['order_id']) && isset($_GET['billing_notes']) && isset($_GET['trans_date']) && isset($_GET['amount']) && isset($_GET['service_tax']) && isset($_GET['tracking_id'])) {
    // Access the specific parameters and convert them to appropriate types
    $order_id = intval($_GET['order_id']);
    $billing_notes = $_GET['billing_notes'];
    $trans_date_str = $_GET['trans_date'];
    $trans_date = date('Y-d-m', strtotime($trans_date_str)); // Correct date format
    $amount = floatval($_GET['mer_amount']); // Correct variable name
    $trans_fee = floatval($_GET['trans_fee']);
    $service_tax = floatval($_GET['service_tax']);
    $tracking_id = floatval($_GET['tracking_id']);
    $bank_ref_no = $_GET['bank_ref_no'];


    // Fetch the maximum receiptno from fees_receipt
    $mx = mysqli_query($conn, "SELECT MAX(receiptno) as receiptno FROM fees_receipt");
    $mx1 = mysqli_fetch_assoc($mx);
    $next_receiptno = $mx1['receiptno'] + 1;

    // Calculate the financial year based on the provided date
    $m = date("m", strtotime($trans_date));
    $y = date("Y", strtotime($trans_date));

    if ($m >= 4) {
        // For April to December months, the financial year is the current year - next year
        $fi = $y;
        $fi_next = $y + 1;
        $aca = $fi . '-' . $fi_next;
    } else {
        // For January to March months, the financial year is the previous year - current year
        $fi = $y - 1;
        $aca = $fi . '-' . $y;
    }

    $fmx = mysqli_query($conn, "SELECT MAX(rno) as rno FROM fees_receipt WHERE financial='$aca'");
    $fmx1 = mysqli_fetch_assoc($fmx);
    $next_rno = $fmx1['rno'] + 1;

    // Query to retrieve data from invoice table based on order_id
    $invoice_query = "SELECT academic, admissionno, academic_year FROM invoice WHERE invoiceno = '$order_id'";
    $invoice_result = mysqli_query($conn, $invoice_query);
    if (!$invoice_result) {
        die('Invoice Query Error: ' . mysqli_error($conn));
    }
    $invoice_row = mysqli_fetch_assoc($invoice_result);

    // Query to retrieve data from admission table based on billing_notes
    $admission_query = "SELECT admissiontype, financial, course FROM admission WHERE admissionno = '$billing_notes'";
    $admission_result = mysqli_query($conn, $admission_query);
    if (!$admission_result) {
        die('Admission Query Error: ' . mysqli_error($conn));
    }
    $admission_row = mysqli_fetch_assoc($admission_result);

    // Build the payment description including service tax and tracking id
    $payment_description = "$bank_ref_no";

    // Insert retrieved data into fees_receipt table
    $insert_query = "INSERT INTO fees_receipt (receiptno, rno, academic, admissionno, academic_year, admissiontype, financial, course, date, amount, trans_fee, service_tax, paymentmode, paymentdescription, description)
                     VALUES ($next_receiptno, $next_rno, '{$invoice_row['academic']}', '{$invoice_row['admissionno']}', '{$invoice_row['academic_year']}', '{$admission_row['admissiontype']}', '$aca', '{$admission_row['course']}', '$trans_date', $amount, $trans_fee, $service_tax, 'CCAvenue', '$payment_description', 'Tuition Fees and Hostel Fees')";

    if (mysqli_query($conn, $insert_query)) {
        // Redirect to collegefees_receipt.php
        header("Location: recipt.php?id=$next_receiptno");
        exit(); // Make sure to exit after redirection
    } else {
        echo "Error inserting data: " . mysqli_error($conn);
    }
} else {
    echo "Required data not received";
}
?>
